package w83b.w83bOperacionesInternas.w83bActas;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bColegiosBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bEdicionActasOIAction extends Q70OperacionInterna{
	/**
	 * preProcessMappingEntrada
	 * @param contexto a
	 * @param configBean a
	 * @param errors a
	 * @throws Exception e
	 */				
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		W83bActasBean acta = (W83bActasBean)contexto.get("w83bNuevaActaBean");
		acta.setColegios((W83bColegiosBean)contexto.get("w83bColegiosBean"));//porque se pierde!!!		
		contexto.set("w83bNuevaActaBean",acta);
		super.preProcessMappingEntrada(contexto, configBean, errors);
			
	}
	
	/**
	 * postProcessMappingSalida
	 * @param contexto a
	 * @param errors a
	 * @throws Exception e
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {

		String resultado = (String)contexto.get("w83bResultado");
		
		boolean errorLibroRegistro = resultado.indexOf("-3") != -1;

		if("-1".equals(resultado)){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.baseDatosLlena", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		}else if("-2".equals(resultado)){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.codPreavisoyaExiste", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		}else if(errorLibroRegistro){
			W83bUtilidadesComunes.anyadirMensajeErrorAplicacion(errors, "error.mensaje.edicionActaOkDocuMal", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));			
			contexto.set("modoPantalla",W83bClsConstantes.MODO_EDICION);
			contexto.set("codSelecEdicion",resultado.substring(0,resultado.length()-2));
		}else{
			contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR, "comun.mensaje.bdActualizadaOk");
			contexto.set("modoPantalla",W83bClsConstantes.MODO_EDICION);
			contexto.set("codSelecEdicion",resultado);

		}
		
		super.postProcessMappingSalida(contexto, errors);
	}
}